Scriptname nwsFollowerOutfitBox_script extends ObjectReference  

; design to be generic to be filled per container

; keywords no longer in use, set to default
Keyword Property ArmorClothing Auto
Keyword Property ArmorLight Auto
Keyword Property ArmorHeavy Auto
Keyword Property ArmorJewelry Auto

FormList Property outfitForm  Auto ; fill to specific outfit form

; Original Code by confusedchim --

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)

	Armor myArmor = akBaseItem as Armor
	if myArmor && myArmor.GetSlotMask()
	; If (akBaseItem.hasKeyword(ArmorClothing) || akBaseItem.hasKeyword(ArmorLight) || akBaseItem.hasKeyword(ArmorHeavy) || akBaseItem.hasKeyword(ArmorJewelry)) ; This is a legal piece of clothing, armor, or jewelry
		outfitForm.AddForm(akBaseItem)
	Else
		RemoveItem(akBaseItem, aiItemCount, True, akSourceContainer)
		debug.notification("You can't use that in an outfit.")
	Endif
EndEvent

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
	outfitForm.RemoveAddedForm(akBaseItem)
EndEvent

